/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.fluid.PotionFluid;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.BrewerRecipe;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final BrewerRecipeManager INSTANCE = new BrewerRecipeManager();
    protected static final int DEFAULT_ENERGY = 4000;
    protected static boolean defaultPotionRecipes = true;
    protected int defaultPotion = 1000;
    protected Map<List<Integer>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 0;
    protected int maxOutputFluids = 1;
    protected List<BrewerRecipe> convertedRecipes = new ArrayList<BrewerRecipe>();

    public static BrewerRecipeManager instance() {
        return INSTANCE;
    }

    private BrewerRecipeManager() {
        super(4000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
            for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(BrewerRecipeManager.convert(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
        this.convertedRecipes.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty() || inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        ItemStack inputItem = inputSlots.get(0).getItemStack();
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(Arrays.asList(BrewerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid)));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || inputFluids.isEmpty() || outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack inputItem = inputItems.get(0);
        if (inputItem.m_41619_()) {
            return null;
        }
        FluidStack inputFluid = inputFluids.get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        for (FluidStack stack : outputFluids) {
            if (!stack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(Arrays.asList(BrewerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid)), recipe);
        this.validItems.add(BrewerRecipeManager.convert(inputItem));
        this.validFluids.add(inputFluid.getFluid());
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        if (defaultPotionRecipes) {
            ThermalCore.LOG.debug("Adding default Brewing Stand recipes to the Alchemical Imbuer...");
            this.createConvertedRecipes();
            for (ThermalRecipe thermalRecipe : this.getConvertedRecipes()) {
                this.addRecipe(thermalRecipe);
            }
        }
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_BREWER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }

    public List<BrewerRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected void createConvertedRecipes() {
        for (PotionBrewing.Mix mix : PotionBrewing.f_43494_) {
            this.createConvertedRecipe((Potion)mix.f_43532_.get(), mix.f_43533_, (Potion)mix.f_43534_.get());
        }
    }

    protected boolean createConvertedRecipe(Potion inputPotion, Ingredient reagent, Potion outputPotion) {
        if (inputPotion == null || reagent == null || outputPotion == null) {
            return false;
        }
        this.convertedRecipes.add(this.convert(inputPotion, reagent, outputPotion));
        return true;
    }

    protected BrewerRecipe convert(Potion inputPotion, Ingredient reagent, Potion outputPotion) {
        return new BrewerRecipe(new ResourceLocation("thermal", "brewer_" + inputPotion.hashCode()), this.defaultEnergy, 0.0f, Collections.singletonList(reagent), Collections.singletonList(FluidIngredient.of((FluidStack[])new FluidStack[]{PotionFluid.getPotionAsFluid((int)this.defaultPotion, (Potion)inputPotion)})), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(PotionFluid.getPotionAsFluid((int)this.defaultPotion, (Potion)outputPotion)));
    }
}

